<?php
$ergebnis = null;

if (isset($_GET['Operation']) && isset($_GET['Zahl1']) && isset($_GET['Zahl2'])) {
  $operation = $_GET['Operation'];
  $zahl1 = $_GET['Zahl1'];
  $zahl2 = $_GET['Zahl2'];

  $ergebnis = calculate($zahl1, $zahl2, $operation);
}

function calculate($zahl1, $zahl2, $operation) {
  switch ($operation) {
    case '-':
      return $zahl1 - $zahl2;

    case '*':
      return $zahl1 * $zahl2;

    case '/':
    case ':':
      if ($zahl2 == 0) {
        return null;
      }

      return $zahl1 / $zahl2;

    default:
      return $zahl1 + $zahl2;
  }
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8" />
  <title>PHP Rechner</title>
</head>
<body>
  <form action="" method="get">
    <?php if ($ergebnis !== null) : ?>
      <div style="color: <?= $ergebnis < 0 ? 'red' : 'green' ?>;">
        <h2><?= $zahl1 ?> <?= $operation ?> <?= $zahl2 ?> = <?= $ergebnis ?></h2>
      </div>
    <?php endif; ?>

    <div>
      <input type="text" name="Zahl1" id="Zahl1" value="<?= isset($zahl1) ? $zahl1 : '' ?>" placeholder="Zahl 1" />

      <select name="Operation" id="Operation">
        <option <?= (isset($operation) && $operation == '+') ? "selected" : '' ?>>+</option>
        <option <?= (isset($operation) && $operation == '-') ? "selected" : '' ?>>-</option>
        <option <?= (isset($operation) && $operation == '*') ? "selected" : '' ?>>*</option>
        <option <?= (isset($operation) && $operation == '/') ? "selected" : '' ?>>/</option>
      </select>

      <input type="text" name="Zahl2" id="Zahl2" value="<?= isset($zahl2) ? $zahl2 : '' ?>" placeholder="Zahl 2" />

      <button type="submit">Berechnen</button>
    </div>
  </form>
</body>
</html>
