import java.util.Scanner;

/**
 *
 * @author bockniclas
 */
public class ABCFormel {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        
        double a;
        double b;
        double c;
        
        // a abfragen und validieren
        System.out.print("Bitte a eingeben: ");
        if (scanner.hasNextDouble()) {
            a = scanner.nextDouble();
            
            if (a == 0.0) {
                System.out.println("a ist Null (0).");

                return;
            }
        } else {
            System.out.println("a muss eine Zahl sein.");
            
            return;
        }
        
        // b abfragen
        System.out.print("Bitte b eingeben: ");
        if (scanner.hasNextDouble()) {
            b = scanner.nextDouble();
        } else {
            System.out.println("b muss eine Zahl sein.");
            
            return;
        }
        
        // c abfragen
        System.out.print("Bitte c eingeben: ");
        if (scanner.hasNextDouble()) {
            c = scanner.nextDouble();
        } else {
            System.out.println("c muss eine Zahl sein.");
            
            return;
        }
        
        scanner.close();
        
        // Wurzelinneres berechnen und validieren
        double wurzelInnen = (b * b) - 4 * a * c;
        if (wurzelInnen < 0.0) {
            System.out.println("Das Innere der Wurzel ist kleiner als Null (0).");
            
            return;
        }

        double wurzel = Math.sqrt(wurzelInnen);
        double geteiltDurch = (2 * a);
        
        
        if (wurzel == 0.0) {
            // Lösung berechnen, wenn es nur ein Ergebnis gibt
            System.out.println("Die Gleichung hat ein Ergebnis: " + (b / geteiltDurch));
        } else {
            // Lösung für zwei Ergebnisse berechnen
            double x1 = (b + wurzel) / geteiltDurch;
            double x2 = (b - wurzel) / geteiltDurch;

            System.out.println("Die Gleichung hat die Ergebnisse " + x1 + " und " + x2 + ".");
        }
    }
    
}
